/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.box_select;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.tutorial.Tutorial;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.marker.MarkerEntityManipulator;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.mask.elements.ConstantMaskElement;
import com.moulberry.axiom.render.EffectRenderer;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.NbtGetter;
import imgui.ImGui;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public class BoxSelectTool
implements Tool {
    private class_2338 dragOrigin = null;
    private boolean dragging = false;
    private Gizmo firstGizmo = null;
    private Gizmo secondGizmo = null;
    private Gizmo centerGizmo = null;
    private final int[] mode = new int[]{1};
    private static final int MODE_REPLACE = 0;
    private static final int MODE_ADD = 1;
    private static final int MODE_SUBTRACT = 2;
    private static final int MODE_INTERSECT = 3;
    private final int[] inputMode = new int[]{0};
    private final int[] position = new int[3];
    private final int[] size = new int[3];

    public boolean handleScroll(int xScroll, int yScroll) {
        if (this.firstGizmo != null && this.secondGizmo != null && this.centerGizmo != null) {
            if (EditorUI.isCtrlOrCmdDown() && !this.firstGizmo.isGrabbed() && !this.secondGizmo.isGrabbed() && !this.centerGizmo.isGrabbed()) {
                return false;
            }
            class_2338 oldCenterPos = this.centerGizmo.getTargetPosition();
            class_243 lookDirection = Tool.getLookDirection();
            if (this.centerGizmo.enableAxes && lookDirection != null) {
                this.centerGizmo.handleScroll(xScroll, yScroll, EditorUI.isCtrlOrCmdDown(), lookDirection);
            }
            class_2338 oldFirstPos = this.firstGizmo.getTargetPosition();
            class_2338 oldSecondPos = this.secondGizmo.getTargetPosition();
            if (!this.centerGizmo.getTargetPosition().equals((Object)oldCenterPos)) {
                class_2338 delta = this.centerGizmo.getTargetPosition().method_10059((class_2382)oldCenterPos);
                this.firstGizmo.moveTo(this.firstGizmo.getTargetPosition().method_10081((class_2382)delta));
                this.secondGizmo.moveTo(this.secondGizmo.getTargetPosition().method_10081((class_2382)delta));
            }
            if (this.firstGizmo.enableAxes && lookDirection != null) {
                this.firstGizmo.handleScroll(xScroll, yScroll, EditorUI.isCtrlOrCmdDown(), lookDirection);
            }
            if (this.secondGizmo.enableAxes && lookDirection != null) {
                this.secondGizmo.handleScroll(xScroll, yScroll, EditorUI.isCtrlOrCmdDown(), lookDirection);
            }
            if (!oldFirstPos.equals((Object)this.firstGizmo.getTargetPosition()) || !oldSecondPos.equals((Object)this.secondGizmo.getTargetPosition())) {
                this.updateGizmoState(oldFirstPos, oldSecondPos);
            }
            return true;
        }
        return false;
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case CUT: 
            case COPY: 
            case DELETE: {
                if (this.dragOrigin != null) {
                    RayCaster.RaycastResult result = Tool.raycastBlock(false, true, true);
                    if (result == null) {
                        return UserAction.ActionResult.NOT_HANDLED;
                    }
                    this.setupGizmos(this.dragOrigin, result.getBlockPos());
                }
                if (this.firstGizmo == null) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                this.reset();
                return UserAction.ActionResult.USED_CONT;
            }
            case ENTER: {
                if (this.dragOrigin != null) {
                    RayCaster.RaycastResult result = Tool.raycastBlock(false, true, true);
                    if (result == null) {
                        return UserAction.ActionResult.NOT_HANDLED;
                    }
                    this.setupGizmos(this.dragOrigin, result.getBlockPos());
                }
                if (this.firstGizmo == null) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
            case LEFT_MOUSE: {
                if (this.leftClick()) {
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case RIGHT_MOUSE: {
                this.rightClick();
                return UserAction.ActionResult.USED_STOP;
            }
            case SCROLL: {
                UserAction.ScrollAmount scrollObject = (UserAction.ScrollAmount)object;
                if (this.handleScroll(scrollObject.scrollX(), scrollObject.scrollY())) {
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case UNDO: {
                if (this.firstGizmo == null && this.dragOrigin == null) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                this.resetWithoutApplyingSelection();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyActiveSelection() {
        class_2338 one = this.firstGizmo.getTargetPosition();
        class_2338 two = this.secondGizmo.getTargetPosition();
        int minX = Math.min(one.method_10263(), two.method_10263());
        int minY = Math.min(one.method_10264(), two.method_10264());
        int minZ = Math.min(one.method_10260(), two.method_10260());
        int maxX = Math.max(one.method_10263(), two.method_10263());
        int maxY = Math.max(one.method_10264(), two.method_10264());
        int maxZ = Math.max(one.method_10260(), two.method_10260());
        MaskElement maskElement = MaskManager.getSelectionMask();
        if (maskElement instanceof ConstantMaskElement) {
            ConstantMaskElement constantMaskElement = (ConstantMaskElement)maskElement;
            if (!constantMaskElement.getConstant()) return;
            int mode = this.mode[0];
            if (mode == 0) {
                Selection.clearSelection();
                Selection.addAABB(new class_2338(minX, minY, minZ), new class_2338(maxX, maxY, maxZ));
                return;
            } else if (mode == 1) {
                Selection.addAABB(new class_2338(minX, minY, minZ), new class_2338(maxX, maxY, maxZ));
                return;
            } else if (mode == 2) {
                Selection.subtractAABB(new class_2338(minX, minY, minZ), new class_2338(maxX, maxY, maxZ));
                return;
            } else {
                if (mode != 3) throw new FaultyImplementationError();
                Selection.intersectAABB(new class_2338(minX, minY, minZ), new class_2338(maxX, maxY, maxZ));
            }
            return;
        } else {
            MaskContext maskContext = new MaskContext((class_1937)class_310.method_1551().field_1687);
            PositionSet positionSet = new PositionSet();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        if (!maskElement.test(maskContext.reset(), x, y, z)) continue;
                        positionSet.add(x, y, z);
                    }
                }
            }
            int mode = this.mode[0];
            if (mode == 0) {
                Selection.clearSelection();
                Selection.addSet(positionSet);
                return;
            } else if (mode == 1) {
                Selection.addSet(positionSet);
                return;
            } else if (mode == 2) {
                Selection.subtractSet(positionSet);
                return;
            } else {
                if (mode != 3) throw new FaultyImplementationError();
                Selection.intersectSet(positionSet);
            }
        }
    }

    @Override
    public void reset() {
        if (this.firstGizmo != null) {
            this.applyActiveSelection();
        }
        this.resetWithoutApplyingSelection();
    }

    private void resetWithoutApplyingSelection() {
        this.dragOrigin = null;
        this.firstGizmo = null;
        this.secondGizmo = null;
        this.centerGizmo = null;
        Arrays.fill(this.position, 0);
        Arrays.fill(this.size, 0);
    }

    private boolean leftClick() {
        if (this.firstGizmo != null && this.secondGizmo != null && this.centerGizmo != null) {
            if (EditorUI.isCtrlOrCmdDown() && !this.firstGizmo.isGrabbed() && !this.secondGizmo.isGrabbed() && !this.centerGizmo.isGrabbed()) {
                return false;
            }
            if (this.centerGizmo.leftClick()) {
                this.firstGizmo.enableAxes = false;
                this.secondGizmo.enableAxes = false;
                return true;
            }
            if (this.firstGizmo.leftClick()) {
                this.centerGizmo.enableAxes = false;
                this.secondGizmo.enableAxes = false;
                return true;
            }
            if (this.secondGizmo.leftClick()) {
                this.centerGizmo.enableAxes = false;
                this.firstGizmo.enableAxes = false;
                return true;
            }
        }
        return false;
    }

    private void rightClick() {
        RayCaster.RaycastResult result;
        if (this.dragOrigin == null) {
            RayCaster.RaycastResult result2 = Tool.raycastBlock(false, true, true);
            if (result2 != null) {
                this.reset();
                this.dragOrigin = result2.getBlockPos();
                this.dragging = true;
                boolean isEmpty = Selection.getSelectionBuffer().isEmpty();
                if (this.mode[0] == 0 && !isEmpty) {
                    Selection.clearSelection();
                } else if (isEmpty && (this.mode[0] == 3 || this.mode[0] == 2)) {
                    this.mode[0] = 0;
                }
            }
        } else if (!this.dragging && (result = Tool.raycastBlock(false, true, true)) != null) {
            for (int i = 0; i < 3; ++i) {
                class_2350.class_2351 axis = class_2350.class_2351.field_23780[i];
                this.position[i] = Math.min(this.dragOrigin.method_30558(axis), result.getBlockPos().method_30558(axis));
                this.size[i] = Math.abs(this.dragOrigin.method_30558(axis) - result.getBlockPos().method_30558(axis)) + 1;
            }
            this.setupGizmos(this.dragOrigin, result.getBlockPos());
        }
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (this.firstGizmo != null) {
            Objects.requireNonNull(this.secondGizmo);
            Objects.requireNonNull(this.centerGizmo);
            Selection.render(camera, time, matrices, projection, 4);
            class_2338 oldCenterPos = this.centerGizmo.getTargetPosition();
            class_243 lookDirection = Tool.getLookDirection();
            boolean isLeftDown = Tool.isMouseDown(0);
            boolean isCtrlDown = EditorUI.isCtrlOrCmdDown();
            boolean showGizmo = !EditorUI.isActive() || !isCtrlDown;
            this.centerGizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
            this.centerGizmo.setAxisDirections(camera.method_19326().field_1352 > (double)this.centerGizmo.getTargetPosition().method_10263(), camera.method_19326().field_1351 > (double)this.centerGizmo.getTargetPosition().method_10264(), camera.method_19326().field_1350 > (double)this.centerGizmo.getTargetPosition().method_10260());
            class_2338 oldFirstPos = this.firstGizmo.getTargetPosition();
            class_2338 oldSecondPos = this.secondGizmo.getTargetPosition();
            if (!this.centerGizmo.getTargetPosition().equals((Object)oldCenterPos)) {
                class_2338 delta = this.centerGizmo.getTargetPosition().method_10059((class_2382)oldCenterPos);
                this.firstGizmo.moveTo(this.firstGizmo.getTargetPosition().method_10081((class_2382)delta));
                this.secondGizmo.moveTo(this.secondGizmo.getTargetPosition().method_10081((class_2382)delta));
            }
            this.firstGizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
            this.secondGizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
            if (!oldFirstPos.equals((Object)this.firstGizmo.getTargetPosition()) || !oldSecondPos.equals((Object)this.secondGizmo.getTargetPosition())) {
                this.updateGizmoState(oldFirstPos, oldSecondPos);
            }
            if (showGizmo || this.firstGizmo.isGrabbed() || this.secondGizmo.isGrabbed() || this.centerGizmo.isGrabbed()) {
                this.firstGizmo.render(matrices, camera, isCtrlDown);
                this.secondGizmo.render(matrices, camera, isCtrlDown);
                this.centerGizmo.render(matrices, camera, isCtrlDown);
            }
            EffectRenderer.renderBoundingBox(camera, time, matrices, this.firstGizmo.getInterpPosition(), this.secondGizmo.getInterpPosition(), 3);
            return;
        }
        if (this.dragOrigin == null) {
            Selection.render(camera, time, matrices, projection, 7);
        } else {
            class_2350.class_2351 axis;
            int i;
            Selection.render(camera, time, matrices, projection, 4);
            RayCaster.RaycastResult result = Tool.raycastBlock(false, true, true);
            if (result != null) {
                for (i = 0; i < 3; ++i) {
                    axis = class_2350.class_2351.field_23780[i];
                    this.position[i] = Math.min(this.dragOrigin.method_30558(axis), result.getBlockPos().method_30558(axis));
                    this.size[i] = Math.abs(this.dragOrigin.method_30558(axis) - result.getBlockPos().method_30558(axis)) + 1;
                }
            } else {
                if (this.dragging) {
                    if (!Tool.isMouseDown(1)) {
                        this.dragOrigin = null;
                    }
                    Arrays.fill(this.position, 0);
                    Arrays.fill(this.size, 0);
                    return;
                }
                return;
            }
            if (!this.dragging || Tool.isMouseDown(1)) {
                float minX = Math.min(this.dragOrigin.method_10263(), result.getBlockPos().method_10263());
                float minY = Math.min(this.dragOrigin.method_10264(), result.getBlockPos().method_10264());
                float minZ = Math.min(this.dragOrigin.method_10260(), result.getBlockPos().method_10260());
                float maxX = Math.max(this.dragOrigin.method_10263(), result.getBlockPos().method_10263());
                float maxY = Math.max(this.dragOrigin.method_10264(), result.getBlockPos().method_10264());
                float maxZ = Math.max(this.dragOrigin.method_10260(), result.getBlockPos().method_10260());
                EffectRenderer.renderBoundingBox(camera, time, matrices, new class_243((double)minX, (double)minY, (double)minZ), new class_243((double)(maxX + 1.0f), (double)(maxY + 1.0f), (double)(maxZ + 1.0f)), 3);
            } else if (this.dragOrigin.equals((Object)result.getBlockPos())) {
                this.dragging = false;
            } else {
                for (i = 0; i < 3; ++i) {
                    axis = class_2350.class_2351.field_23780[i];
                    this.position[i] = Math.min(this.dragOrigin.method_30558(axis), result.getBlockPos().method_30558(axis));
                    this.size[i] = Math.abs(this.dragOrigin.method_30558(axis) - result.getBlockPos().method_30558(axis)) + 1;
                }
                this.setupGizmos(this.dragOrigin, result.getBlockPos());
            }
        }
    }

    private void setupGizmos(class_2338 first, class_2338 second) {
        float offsetX = first.method_10263() <= second.method_10263() ? -0.5f : 0.5f;
        float offsetY = first.method_10264() <= second.method_10264() ? -0.5f : 0.5f;
        float offsetZ = first.method_10260() <= second.method_10260() ? -0.5f : 0.5f;
        float centerX = (float)(first.method_10263() + second.method_10263()) / 2.0f;
        float centerY = (float)(first.method_10264() + second.method_10264()) / 2.0f;
        float centerZ = (float)(first.method_10260() + second.method_10260()) / 2.0f;
        this.firstGizmo = new Gizmo(first, new class_243((double)offsetX, (double)offsetY, (double)offsetZ));
        this.secondGizmo = new Gizmo(second, new class_243((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ)));
        this.centerGizmo = new Gizmo(class_2338.method_49637((double)centerX, (double)centerY, (double)centerZ), new class_243((double)centerX - Math.floor(centerX), (double)centerY - Math.floor(centerY), (double)centerZ - Math.floor(centerZ)));
        boolean firstXGreater = this.firstGizmo.getInterpPosition().method_10216() > this.secondGizmo.getInterpPosition().method_10216();
        boolean firstYGreater = this.firstGizmo.getInterpPosition().method_10214() > this.secondGizmo.getInterpPosition().method_10214();
        boolean firstZGreater = this.firstGizmo.getInterpPosition().method_10215() > this.secondGizmo.getInterpPosition().method_10215();
        this.firstGizmo.setAxisDirections(firstXGreater, firstYGreater, firstZGreater);
        this.secondGizmo.setAxisDirections(!firstXGreater, !firstYGreater, !firstZGreater);
        this.firstGizmo.enableAxes = false;
        this.secondGizmo.enableAxes = true;
        this.centerGizmo.enableAxes = false;
        this.dragOrigin = null;
    }

    private void updateGizmoState(class_2338 oldFirstPos, class_2338 oldSecondPos) {
        this.maybeSwapOffsetsForAxis(oldFirstPos, oldSecondPos, class_2350.class_2351.field_11048);
        this.maybeSwapOffsetsForAxis(oldFirstPos, oldSecondPos, class_2350.class_2351.field_11052);
        this.maybeSwapOffsetsForAxis(oldFirstPos, oldSecondPos, class_2350.class_2351.field_11051);
        class_2338 firstPos = this.firstGizmo.getTargetPosition();
        class_2338 secondPos = this.secondGizmo.getTargetPosition();
        boolean firstXGreater = this.firstGizmo.getInterpPosition().method_10216() > this.secondGizmo.getInterpPosition().method_10216();
        boolean firstYGreater = this.firstGizmo.getInterpPosition().method_10214() > this.secondGizmo.getInterpPosition().method_10214();
        boolean firstZGreater = this.firstGizmo.getInterpPosition().method_10215() > this.secondGizmo.getInterpPosition().method_10215();
        this.firstGizmo.setAxisDirections(firstXGreater, firstYGreater, firstZGreater);
        this.secondGizmo.setAxisDirections(!firstXGreater, !firstYGreater, !firstZGreater);
        float centerX = (float)(firstPos.method_10263() + secondPos.method_10263()) / 2.0f;
        float centerY = (float)(firstPos.method_10264() + secondPos.method_10264()) / 2.0f;
        float centerZ = (float)(firstPos.method_10260() + secondPos.method_10260()) / 2.0f;
        this.centerGizmo.moveTo(class_2338.method_49637((double)centerX, (double)centerY, (double)centerZ));
        this.centerGizmo.setOffset(new class_243((double)centerX - Math.floor(centerX), (double)centerY - Math.floor(centerY), (double)centerZ - Math.floor(centerZ)));
        for (int i = 0; i < 3; ++i) {
            class_2350.class_2351 axis = class_2350.class_2351.field_23780[i];
            this.position[i] = Math.min(firstPos.method_30558(axis), secondPos.method_30558(axis));
            this.size[i] = Math.abs(firstPos.method_30558(axis) - secondPos.method_30558(axis)) + 1;
        }
    }

    private void maybeSwapOffsetsForAxis(class_2338 oldFirstPos, class_2338 oldSecondPos, class_2350.class_2351 axis) {
        int size = this.firstGizmo.getTargetPosition().method_30558(axis) - this.secondGizmo.getTargetPosition().method_30558(axis);
        if (size > 0 && this.firstGizmo.getOffset().method_18043(axis) < 0.0 || size < 0 && this.firstGizmo.getOffset().method_18043(axis) > 0.0) {
            double temp = this.firstGizmo.getOffset().method_18043(axis);
            this.firstGizmo.setOffset(this.firstGizmo.getOffset().method_38499(axis, this.secondGizmo.getOffset().method_18043(axis)));
            this.secondGizmo.setOffset(this.secondGizmo.getOffset().method_38499(axis, temp));
            int firstDelta = oldFirstPos.method_30558(axis) - this.firstGizmo.getTargetPosition().method_30558(axis);
            if (firstDelta > 0) {
                this.firstGizmo.moveTo(this.firstGizmo.getTargetPosition().method_30513(axis, 1));
            } else if (firstDelta < 0) {
                this.firstGizmo.moveTo(this.firstGizmo.getTargetPosition().method_30513(axis, -1));
            }
            int secondDelta = oldSecondPos.method_30558(axis) - this.secondGizmo.getTargetPosition().method_30558(axis);
            if (secondDelta > 0) {
                this.secondGizmo.moveTo(this.secondGizmo.getTargetPosition().method_30513(axis, 1));
            } else if (secondDelta < 0) {
                this.secondGizmo.moveTo(this.secondGizmo.getTargetPosition().method_30513(axis, -1));
            }
        }
    }

    private void updateGizmosFromPositionSize() {
        for (int i = 0; i < 4; ++i) {
            if (i == 3) {
                return;
            }
            if (this.position[i] != 0 || this.size[i] != 0) break;
        }
        if (this.firstGizmo == null) {
            class_2338 first = new class_2338(this.position[0], this.position[1], this.position[2]);
            class_2338 second = first.method_10069(this.size[0], this.size[1], this.size[2]);
            this.setupGizmos(first, second);
            return;
        }
        class_2338 oldFirstPos = this.firstGizmo.getTargetPosition();
        class_2338 oldSecondPos = this.secondGizmo.getTargetPosition();
        class_2338.class_2339 newFirstPos = new class_2338.class_2339();
        class_2338.class_2339 newSecondPos = new class_2338.class_2339();
        block6: for (int i = 0; i < 3; ++i) {
            class_2338.class_2339 greater;
            class_2338.class_2339 lesser;
            int oldSecondPosAxis;
            class_2350.class_2351 axis = class_2350.class_2351.field_23780[i];
            int oldFirstPosAxis = oldFirstPos.method_30558(axis);
            if (oldFirstPosAxis < (oldSecondPosAxis = oldSecondPos.method_30558(axis))) {
                lesser = newFirstPos;
                greater = newSecondPos;
            } else if (oldFirstPosAxis > oldSecondPosAxis) {
                lesser = newSecondPos;
                greater = newFirstPos;
            } else {
                double secondOffsetAxis;
                double firstOffsetAxis = this.firstGizmo.getOffset().method_18043(axis);
                if (firstOffsetAxis < (secondOffsetAxis = this.secondGizmo.getOffset().method_18043(axis))) {
                    lesser = newFirstPos;
                    greater = newSecondPos;
                } else if (firstOffsetAxis > secondOffsetAxis) {
                    lesser = newSecondPos;
                    greater = newFirstPos;
                } else {
                    throw new FaultyImplementationError("Offsets are equal");
                }
            }
            if (this.size[i] == 0) {
                this.size[i] = 1;
            } else if (this.size[i] < 0) {
                int n = i;
                this.position[n] = this.position[n] + this.size[i];
                this.size[i] = Math.abs(this.size[i]);
            }
            switch (axis) {
                case field_11048: {
                    lesser.method_33097(this.position[i]);
                    greater.method_33097(this.position[i] + this.size[i] - 1);
                    continue block6;
                }
                case field_11052: {
                    lesser.method_33098(this.position[i]);
                    greater.method_33098(this.position[i] + this.size[i] - 1);
                    continue block6;
                }
                case field_11051: {
                    lesser.method_33099(this.position[i]);
                    greater.method_33099(this.position[i] + this.size[i] - 1);
                }
            }
        }
        this.firstGizmo.moveTo((class_2338)newFirstPos);
        this.secondGizmo.moveTo((class_2338)newSecondPos);
        if (!oldFirstPos.equals((Object)this.firstGizmo.getTargetPosition()) || !oldSecondPos.equals((Object)this.secondGizmo.getTargetPosition())) {
            this.updateGizmoState(oldFirstPos, oldSecondPos);
        }
    }

    private void shrinkToFit() {
        int ly;
        int toX;
        int fromX;
        int toY;
        int fromY;
        int y;
        int ly2;
        int lx;
        int lz;
        int toX2;
        int fromX2;
        int x;
        int toZ;
        int fromZ;
        int z;
        int lz2;
        int ly3;
        int lx2;
        class_2841 states;
        class_2826 section;
        int toY2;
        int fromY2;
        int y2;
        class_2818 chunk;
        int toZ2;
        int fromZ2;
        int z2;
        int toX3;
        int fromX3;
        int x2;
        if (this.firstGizmo == null) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        int minWorldSectionY = level.method_32891();
        class_2338 firstPosition = this.firstGizmo.getTargetPosition();
        class_2338 secondPosition = this.secondGizmo.getTargetPosition();
        class_2338.class_2339 minPosition = new class_2338.class_2339(Math.min(firstPosition.method_10263(), secondPosition.method_10263()), Math.max(Math.min(firstPosition.method_10264(), secondPosition.method_10264()), level.method_31607()), Math.min(firstPosition.method_10260(), secondPosition.method_10260()));
        class_2338.class_2339 maxPosition = new class_2338.class_2339(Math.max(firstPosition.method_10263(), secondPosition.method_10263()), Math.min(Math.max(firstPosition.method_10264(), secondPosition.method_10264()), level.method_31600() - 1), Math.max(firstPosition.method_10260(), secondPosition.method_10260()));
        int minSectionX = minPosition.method_10263() >> 4;
        int minSectionY = minPosition.method_10264() >> 4;
        int minSectionZ = minPosition.method_10260() >> 4;
        int maxSectionX = maxPosition.method_10263() >> 4;
        int maxSectionY = maxPosition.method_10264() >> 4;
        int maxSectionZ = maxPosition.method_10260() >> 4;
        boolean foundAnyBlock = false;
        int locMinX = minPosition.method_10263() & 0xF;
        int locMinY = minPosition.method_10264() & 0xF;
        int locMinZ = minPosition.method_10260() & 0xF;
        int locMaxX = maxPosition.method_10263() & 0xF;
        int locMaxY = maxPosition.method_10264() & 0xF;
        int locMaxZ = maxPosition.method_10260() & 0xF;
        for (x2 = minSectionX; x2 <= maxSectionX; ++x2) {
            fromX3 = x2 == minSectionX ? locMinX : 0;
            toX3 = x2 == maxSectionX ? locMaxX : 15;
            int foundMinX = toX3 + 1;
            block1: for (z2 = minSectionZ; z2 <= maxSectionZ; ++z2) {
                fromZ2 = z2 == minSectionZ ? locMinZ : 0;
                toZ2 = z2 == maxSectionZ ? locMaxZ : 15;
                chunk = level.method_8497(x2, z2);
                for (y2 = minSectionY; y2 <= maxSectionY; ++y2) {
                    fromY2 = y2 == minSectionY ? locMinY : 0;
                    toY2 = y2 == maxSectionY ? locMaxY : 15;
                    section = chunk.method_38259(y2 - minWorldSectionY);
                    if (section.method_38292()) continue;
                    states = section.method_12265();
                    block3: for (lx2 = fromX3; lx2 < foundMinX; ++lx2) {
                        for (ly3 = fromY2; ly3 <= toY2; ++ly3) {
                            for (lz2 = fromZ2; lz2 <= toZ2; ++lz2) {
                                if (((class_2680)states.method_12321(lx2, ly3, lz2)).method_26215()) continue;
                                foundMinX = lx2;
                                break block3;
                            }
                        }
                    }
                    if (foundMinX == fromX3) break block1;
                }
            }
            if (foundMinX >= toX3 + 1) continue;
            foundAnyBlock = true;
            minPosition.method_33097(x2 * 16 + foundMinX);
            minSectionX = minPosition.method_10263() >> 4;
            locMinX = minPosition.method_10263() & 0xF;
            break;
        }
        if (!foundAnyBlock) {
            this.resetWithoutApplyingSelection();
            return;
        }
        for (x2 = maxSectionX; x2 >= minSectionX; --x2) {
            fromX3 = x2 == minSectionX ? locMinX : 0;
            toX3 = x2 == maxSectionX ? locMaxX : 15;
            int foundMaxX = fromX3 - 1;
            block7: for (z2 = minSectionZ; z2 <= maxSectionZ; ++z2) {
                fromZ2 = z2 == minSectionZ ? locMinZ : 0;
                toZ2 = z2 == maxSectionZ ? locMaxZ : 15;
                chunk = level.method_8497(x2, z2);
                for (y2 = minSectionY; y2 <= maxSectionY; ++y2) {
                    fromY2 = y2 == minSectionY ? locMinY : 0;
                    toY2 = y2 == maxSectionY ? locMaxY : 15;
                    section = chunk.method_38259(y2 - minWorldSectionY);
                    if (section.method_38292()) continue;
                    states = section.method_12265();
                    block9: for (lx2 = toX3; lx2 > foundMaxX; --lx2) {
                        for (ly3 = fromY2; ly3 <= toY2; ++ly3) {
                            for (lz2 = fromZ2; lz2 <= toZ2; ++lz2) {
                                if (((class_2680)states.method_12321(lx2, ly3, lz2)).method_26215()) continue;
                                foundMaxX = lx2;
                                break block9;
                            }
                        }
                    }
                    if (foundMaxX == toX3) break block7;
                }
            }
            if (foundMaxX <= fromX3 - 1) continue;
            maxPosition.method_33097(x2 * 16 + foundMaxX);
            maxSectionX = maxPosition.method_10263() >> 4;
            locMaxX = maxPosition.method_10263() & 0xF;
            break;
        }
        for (z = minSectionZ; z <= maxSectionZ; ++z) {
            fromZ = z == minSectionZ ? locMinZ : 0;
            toZ = z == maxSectionZ ? locMaxZ : 15;
            int foundMinZ = toZ + 1;
            block13: for (x = minSectionX; x <= maxSectionX; ++x) {
                fromX2 = x == minSectionX ? locMinX : 0;
                toX2 = x == maxSectionX ? locMaxX : 15;
                chunk = level.method_8497(x, z);
                for (y2 = minSectionY; y2 <= maxSectionY; ++y2) {
                    fromY2 = y2 == minSectionY ? locMinY : 0;
                    toY2 = y2 == maxSectionY ? locMaxY : 15;
                    section = chunk.method_38259(y2 - minWorldSectionY);
                    if (section.method_38292()) continue;
                    states = section.method_12265();
                    block15: for (lz = fromZ; lz < foundMinZ; ++lz) {
                        for (lx = fromX2; lx <= toX2; ++lx) {
                            for (ly2 = fromY2; ly2 <= toY2; ++ly2) {
                                if (((class_2680)states.method_12321(lx, ly2, lz)).method_26215()) continue;
                                foundMinZ = lz;
                                break block15;
                            }
                        }
                    }
                    if (foundMinZ == fromZ) break block13;
                }
            }
            if (foundMinZ >= toZ + 1) continue;
            minPosition.method_33099(z * 16 + foundMinZ);
            minSectionZ = minPosition.method_10260() >> 4;
            locMinZ = minPosition.method_10260() & 0xF;
            break;
        }
        for (z = maxSectionZ; z >= minSectionZ; --z) {
            fromZ = z == minSectionZ ? locMinZ : 0;
            toZ = z == maxSectionZ ? locMaxZ : 15;
            int foundMaxZ = fromZ - 1;
            block19: for (x = minSectionX; x <= maxSectionX; ++x) {
                fromX2 = x == minSectionX ? locMinX : 0;
                toX2 = x == maxSectionX ? locMaxX : 15;
                chunk = level.method_8497(x, z);
                for (y2 = minSectionY; y2 <= maxSectionY; ++y2) {
                    fromY2 = y2 == minSectionY ? locMinY : 0;
                    toY2 = y2 == maxSectionY ? locMaxY : 15;
                    section = chunk.method_38259(y2 - minWorldSectionY);
                    if (section.method_38292()) continue;
                    states = section.method_12265();
                    block21: for (lz = toZ; lz > foundMaxZ; --lz) {
                        for (lx = fromX2; lx <= toX2; ++lx) {
                            for (ly2 = fromY2; ly2 <= toY2; ++ly2) {
                                if (((class_2680)states.method_12321(lx, ly2, lz)).method_26215()) continue;
                                foundMaxZ = lz;
                                break block21;
                            }
                        }
                    }
                    if (foundMaxZ == toZ) break block19;
                }
            }
            if (foundMaxZ <= fromZ - 1) continue;
            maxPosition.method_33099(z * 16 + foundMaxZ);
            maxSectionZ = maxPosition.method_10260() >> 4;
            locMaxZ = maxPosition.method_10260() & 0xF;
            break;
        }
        for (y = minSectionY; y <= maxSectionY; ++y) {
            fromY = y == minSectionY ? locMinY : 0;
            toY = y == maxSectionY ? locMaxY : 15;
            int foundMinY = toY + 1;
            block25: for (z2 = minSectionZ; z2 <= maxSectionZ; ++z2) {
                fromZ2 = z2 == minSectionZ ? locMinZ : 0;
                toZ2 = z2 == maxSectionZ ? locMaxZ : 15;
                for (int x3 = minSectionX; x3 <= maxSectionX; ++x3) {
                    fromX = x3 == minSectionX ? locMinX : 0;
                    toX = x3 == maxSectionX ? locMaxX : 15;
                    class_2818 chunk2 = level.method_8497(x3, z2);
                    section = chunk2.method_38259(y - minWorldSectionY);
                    if (section.method_38292()) continue;
                    states = section.method_12265();
                    block27: for (ly = fromY; ly < foundMinY; ++ly) {
                        for (lx = fromX; lx <= toX; ++lx) {
                            for (lz2 = fromZ2; lz2 <= toZ2; ++lz2) {
                                if (((class_2680)states.method_12321(lx, ly, lz2)).method_26215()) continue;
                                foundMinY = ly;
                                break block27;
                            }
                        }
                    }
                    if (foundMinY == fromY) break block25;
                }
            }
            if (foundMinY >= toY + 1) continue;
            minPosition.method_33098(y * 16 + foundMinY);
            minSectionY = minPosition.method_10264() >> 4;
            locMinY = minPosition.method_10264() & 0xF;
            break;
        }
        for (y = maxSectionY; y >= minSectionY; --y) {
            fromY = y == minSectionY ? locMinY : 0;
            toY = y == maxSectionY ? locMaxY : 15;
            int foundMaxY = fromY - 1;
            block31: for (z2 = minSectionZ; z2 <= maxSectionZ; ++z2) {
                fromZ2 = z2 == minSectionZ ? locMinZ : 0;
                toZ2 = z2 == maxSectionZ ? locMaxZ : 15;
                for (int x4 = minSectionX; x4 <= maxSectionX; ++x4) {
                    fromX = x4 == minSectionX ? locMinX : 0;
                    toX = x4 == maxSectionX ? locMaxX : 15;
                    class_2818 chunk3 = level.method_8497(x4, z2);
                    section = chunk3.method_38259(y - minWorldSectionY);
                    if (section.method_38292()) continue;
                    states = section.method_12265();
                    block33: for (ly = toY; ly > foundMaxY; --ly) {
                        for (lx = fromX; lx <= toX; ++lx) {
                            for (lz2 = fromZ2; lz2 <= toZ2; ++lz2) {
                                if (((class_2680)states.method_12321(lx, ly, lz2)).method_26215()) continue;
                                foundMaxY = ly;
                                break block33;
                            }
                        }
                    }
                    if (foundMaxY == toY) break block31;
                }
            }
            if (foundMaxY <= fromY - 1) continue;
            maxPosition.method_33098(y * 16 + foundMaxY);
            break;
        }
        this.position[0] = minPosition.method_10263();
        this.position[1] = minPosition.method_10264();
        this.position[2] = minPosition.method_10260();
        this.size[0] = maxPosition.method_10263() - minPosition.method_10263() + 1;
        this.size[1] = maxPosition.method_10264() - minPosition.method_10264() + 1;
        this.size[2] = maxPosition.method_10260() - minPosition.method_10260() + 1;
        this.updateGizmosFromPositionSize();
    }

    @Override
    public void displayImguiOptions() {
        boolean shrinkDisabled;
        boolean sizePositive;
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.box_select"));
        ImGuiHelper.combo(AxiomI18n.get("axiom.tool.box_select.input_mode"), this.inputMode, new String[]{AxiomI18n.get("axiom.tool.box_select.input_mode.position_and_size"), AxiomI18n.get("axiom.tool.box_select.input_mode.pos1_and_pos2")});
        boolean changed = false;
        if (this.inputMode[0] == 0) {
            changed |= ImGuiHelper.inputInt(AxiomI18n.get("axiom.tool.box_select.position"), this.position);
            changed |= ImGuiHelper.inputInt(AxiomI18n.get("axiom.tool.box_select.size"), this.size);
        } else {
            int[] pos1 = new int[]{0, 0, 0};
            int[] pos2 = new int[]{0, 0, 0};
            if (this.firstGizmo != null) {
                class_2338 first = this.firstGizmo.getTargetPosition();
                pos1[0] = first.method_10263();
                pos1[1] = first.method_10264();
                pos1[2] = first.method_10260();
            }
            if (this.secondGizmo != null) {
                class_2338 second = this.secondGizmo.getTargetPosition();
                pos2[0] = second.method_10263();
                pos2[1] = second.method_10264();
                pos2[2] = second.method_10260();
            }
            changed |= ImGuiHelper.inputInt(AxiomI18n.get("axiom.tool.box_select.pos1"), pos1);
            if (changed |= ImGuiHelper.inputInt(AxiomI18n.get("axiom.tool.box_select.pos2"), pos2)) {
                if (this.firstGizmo != null && this.secondGizmo != null) {
                    class_2338 oldFirstPos = this.firstGizmo.getTargetPosition();
                    class_2338 oldSecondPos = this.secondGizmo.getTargetPosition();
                    this.firstGizmo.moveTo(new class_2338(pos1[0], pos1[1], pos1[2]));
                    this.secondGizmo.moveTo(new class_2338(pos2[0], pos2[1], pos2[2]));
                    this.maybeSwapOffsetsForAxis(oldFirstPos, oldSecondPos, class_2350.class_2351.field_11048);
                    this.maybeSwapOffsetsForAxis(oldFirstPos, oldSecondPos, class_2350.class_2351.field_11052);
                    this.maybeSwapOffsetsForAxis(oldFirstPos, oldSecondPos, class_2350.class_2351.field_11051);
                }
                this.position[0] = Math.min(pos1[0], pos2[0]);
                this.position[1] = Math.min(pos1[1], pos2[1]);
                this.position[2] = Math.min(pos1[2], pos2[2]);
                this.size[0] = Math.abs(pos1[0] - pos2[0]) + 1;
                this.size[1] = Math.abs(pos1[1] - pos2[1]) + 1;
                this.size[2] = Math.abs(pos1[2] - pos2[2]) + 1;
            }
        }
        boolean bl = sizePositive = this.size[0] >= 0 && this.size[1] >= 0 && this.size[2] >= 0;
        if (!(!changed && sizePositive || ImGui.isAnyItemActive() && !sizePositive)) {
            this.updateGizmosFromPositionSize();
        }
        boolean bl2 = shrinkDisabled = this.firstGizmo == null;
        if (shrinkDisabled) {
            ImGui.beginDisabled();
        }
        if (ImGui.button(AxiomI18n.get("axiom.tool.box_select.shrink"))) {
            this.shrinkToFit();
        }
        if (shrinkDisabled) {
            ImGui.endDisabled();
        }
        ImGui.sameLine();
        ImGuiHelper.helpMarker(AxiomI18n.get("axiom.tool.box_select.shrink_description"));
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.selection"));
        ImGuiHelper.combo(AxiomI18n.get("axiom.tool.selection.mode"), this.mode, new String[]{AxiomI18n.get("axiom.tool.selection.replace"), AxiomI18n.get("axiom.tool.selection.add"), AxiomI18n.get("axiom.tool.selection.subtract"), AxiomI18n.get("axiom.tool.selection.intersect")});
        if (this.firstGizmo != null) {
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.selection.actions"));
            if (ImGui.button(AxiomI18n.get("axiom.tool.selection.confirm_selection", "Enter"))) {
                this.reset();
            }
        } else if (Selection.selectedBlockCount() > 0) {
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.selection.actions"));
            if (ImGui.button(AxiomI18n.get("axiom.tool.selection.clear_selection", "Enter"))) {
                Selection.clearSelection();
            }
        }
        if (Configuration.rendering.showMarkerEntities) {
            if (this.firstGizmo != null) {
                if (ImGui.button(AxiomI18n.get("axiom.tool.box_select.box_select.create_marker_region"))) {
                    first = this.firstGizmo.getTargetPosition();
                    class_2338 second = this.secondGizmo.getTargetPosition();
                    MarkerEntityManipulator.spawnNewMarkerRegion((class_2338)first, second);
                }
            } else {
                first = Selection.getSelectionBuffer();
                if (first instanceof SelectionBuffer.AABB) {
                    SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)first;
                    if (ImGui.button(AxiomI18n.get("axiom.tool.box_select.box_select.create_marker_region"))) {
                        first = aabb.min();
                        class_2338 second = aabb.max();
                        MarkerEntityManipulator.spawnNewMarkerRegion((class_2338)first, second);
                    }
                }
            }
        }
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.box_select");
    }

    @Override
    public Tutorial getTutorial() {
        return Tutorial.BOX_SELECT_TOOL;
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        throw new UnsupportedOperationException("Box Select Tool is not a source");
    }

    @Override
    public void writeSettings(class_2487 tag) {
        tag.method_10567("SelectionMode", (byte)this.mode[0]);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.mode[0] = NbtGetter.getIntOrDefault(tag, "SelectionMode", 1);
    }

    @Override
    public char iconChar() {
        return '\ue903';
    }

    @Override
    public String keybindId() {
        return "box_select";
    }

    @Override
    public int defaultKeybind() {
        return 66;
    }
}

